/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MethodResult {
    private static final MethodResult empty = new MethodResult(null, null);
    private final Object[] result;
    private final ILuaCallback callback;
    private final int adjust;

    private MethodResult(Object[] arguments, ILuaCallback callback) {
        this.result = arguments;
        this.callback = callback;
        this.adjust = 0;
    }

    private MethodResult(Object[] arguments, ILuaCallback callback, int adjust) {
        this.result = arguments;
        this.callback = callback;
        this.adjust = adjust;
    }

    @Nonnull
    public static MethodResult of() {
        return empty;
    }

    @Nonnull
    public static MethodResult of(@Nullable Object value) {
        return new MethodResult(new Object[]{value}, null);
    }

    @Nonnull
    public static MethodResult of(Object ... values) {
        return values == null || values.length == 0 ? empty : new MethodResult(values, null);
    }

    @Nonnull
    public static MethodResult pullEvent(@Nullable String filter, @Nonnull ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(new Object[]{filter}, results -> {
            if (results.length >= 1 && Objects.equals(results[0], "terminate")) {
                throw new LuaException("Terminated", 0);
            }
            return callback.resume(results);
        });
    }

    @Nonnull
    public static MethodResult pullEventRaw(@Nullable String filter, @Nonnull ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(new Object[]{filter}, callback);
    }

    @Nonnull
    public static MethodResult yield(@Nullable Object[] arguments, @Nonnull ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(arguments, callback);
    }

    @Nullable
    public Object[] getResult() {
        return this.result;
    }

    @Nullable
    public ILuaCallback getCallback() {
        return this.callback;
    }

    public int getErrorAdjust() {
        return this.adjust;
    }

    @Nonnull
    public MethodResult adjustError(int adjust) {
        if (adjust < 0) {
            throw new IllegalArgumentException("cannot adjust by a negative amount");
        }
        if (adjust == 0 || this.callback == null) {
            return this;
        }
        return new MethodResult(this.result, this.callback, this.adjust + adjust);
    }
}

